package net.w_horse.excelpojo.converter;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.converter.StringBooleanConverter.CapitalizeType;

public class StringBooleanConverterTest extends AbstractTest {

	/**
	 * ftHg̕ϊ
	 * @throws ExcelPOJOException
	 */
	@Test
	public void testDefault() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(true, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(true, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(true, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("false", converter.convertField2Cell("true"));
		assertEquals("false", converter.convertField2Cell("false"));
		assertEquals("false", converter.convertField2Cell("TRUE"));
		assertEquals("false", converter.convertField2Cell("FALSE"));
		assertEquals("false", converter.convertField2Cell("True"));
		assertEquals("false", converter.convertField2Cell("False"));
		assertEquals("false", converter.convertField2Cell("tRue"));
		assertEquals("false", converter.convertField2Cell("fAlse"));
		assertEquals("true", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("false", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("true", converter.convertField2Cell(true));
		assertEquals("false", converter.convertField2Cell(false));
		assertEquals("false", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testYesNo() throws ExcelPOJOException {
		StringBooleanConverter converter
			= new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_YES_NO);
		assertEquals(true, converter.convertCell2Field("Yes"));
		assertEquals(false, converter.convertCell2Field("No"));
		assertEquals(true, converter.convertCell2Field("YES"));
		assertEquals(false, converter.convertCell2Field("NO"));
		assertEquals(true, converter.convertCell2Field("yes"));
		assertEquals(false, converter.convertCell2Field("no"));
		assertEquals(true, converter.convertCell2Field("Y"));
		assertEquals(false, converter.convertCell2Field("N"));
		assertEquals(true, converter.convertCell2Field("y"));
		assertEquals(false, converter.convertCell2Field("n"));
		assertEquals(true, converter.convertCell2Field("YeS"));
		assertEquals(false, converter.convertCell2Field("nO"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals("no", converter.convertField2Cell("Yes"));
		assertEquals("no", converter.convertField2Cell("No"));
		assertEquals("no", converter.convertField2Cell("YES"));
		assertEquals("no", converter.convertField2Cell("NO"));
		assertEquals("no", converter.convertField2Cell("yes"));
		assertEquals("no", converter.convertField2Cell("no"));
		assertEquals("no", converter.convertField2Cell("Y"));
		assertEquals("no", converter.convertField2Cell("N"));
		assertEquals("no", converter.convertField2Cell("y"));
		assertEquals("no", converter.convertField2Cell("n"));
		assertEquals("no", converter.convertField2Cell("YeS"));
		assertEquals("no", converter.convertField2Cell("nO"));
		assertEquals("yes", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("no", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("yes", converter.convertField2Cell(true));
		assertEquals("no", converter.convertField2Cell(false));
		assertEquals("no", converter.convertField2Cell("XXX"));
		assertEquals("no", converter.convertField2Cell("true"));
		assertEquals("no", converter.convertField2Cell("false"));
	}

	@Test
	public void testCapitalizeUpperCase() throws ExcelPOJOException {
		StringBooleanConverter converter
			= new StringBooleanConverter();
		converter.setCapitalizeType(CapitalizeType.UPPER_CASE);
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(true, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(true, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(true, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("FALSE", converter.convertField2Cell("true"));
		assertEquals("FALSE", converter.convertField2Cell("false"));
		assertEquals("FALSE", converter.convertField2Cell("TRUE"));
		assertEquals("FALSE", converter.convertField2Cell("FALSE"));
		assertEquals("FALSE", converter.convertField2Cell("True"));
		assertEquals("FALSE", converter.convertField2Cell("False"));
		assertEquals("FALSE", converter.convertField2Cell("tRue"));
		assertEquals("FALSE", converter.convertField2Cell("fAlse"));
		assertEquals("TRUE", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("FALSE", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("TRUE", converter.convertField2Cell(true));
		assertEquals("FALSE", converter.convertField2Cell(false));
		assertEquals("FALSE", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testIgnoreCaseNo() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setIgnoreCase(false);
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(false, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(false, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(false, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("false", converter.convertField2Cell("true"));
		assertEquals("false", converter.convertField2Cell("false"));
		assertEquals("false", converter.convertField2Cell("TRUE"));
		assertEquals("false", converter.convertField2Cell("FALSE"));
		assertEquals("false", converter.convertField2Cell("True"));
		assertEquals("false", converter.convertField2Cell("False"));
		assertEquals("false", converter.convertField2Cell("tRue"));
		assertEquals("false", converter.convertField2Cell("fAlse"));
		assertEquals("true", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("false", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("true", converter.convertField2Cell(true));
		assertEquals("false", converter.convertField2Cell(false));
		assertEquals("false", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testYesNoIgnoreCaseYes() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_YES_NO);
		converter.setIgnoreCase(true);
		assertEquals(true, converter.convertCell2Field("Yes"));
		assertEquals(false, converter.convertCell2Field("No"));
		assertEquals(true, converter.convertCell2Field("YES"));
		assertEquals(false, converter.convertCell2Field("NO"));
		assertEquals(true, converter.convertCell2Field("yes"));
		assertEquals(false, converter.convertCell2Field("no"));
		assertEquals(true, converter.convertCell2Field("Y"));
		assertEquals(false, converter.convertCell2Field("N"));
		assertEquals(true, converter.convertCell2Field("y"));
		assertEquals(false, converter.convertCell2Field("n"));
		assertEquals(true, converter.convertCell2Field("YeS"));
		assertEquals(false, converter.convertCell2Field("nO"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("no", converter.convertField2Cell("Yes"));
		assertEquals("no", converter.convertField2Cell("No"));
		assertEquals("no", converter.convertField2Cell("YES"));
		assertEquals("no", converter.convertField2Cell("NO"));
		assertEquals("no", converter.convertField2Cell("yes"));
		assertEquals("no", converter.convertField2Cell("no"));
		assertEquals("no", converter.convertField2Cell("Y"));
		assertEquals("no", converter.convertField2Cell("N"));
		assertEquals("no", converter.convertField2Cell("y"));
		assertEquals("no", converter.convertField2Cell("n"));
		assertEquals("no", converter.convertField2Cell("YeS"));
		assertEquals("no", converter.convertField2Cell("nO"));
		assertEquals("yes", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("no", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("yes", converter.convertField2Cell(true));
		assertEquals("no", converter.convertField2Cell(false));
		assertEquals("no", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testYesNoIgnoreCaseNo() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_YES_NO);
		converter.setIgnoreCase(false);
		assertEquals(false, converter.convertCell2Field("Yes"));
		assertEquals(false, converter.convertCell2Field("No"));
		assertEquals(false, converter.convertCell2Field("YES"));
		assertEquals(false, converter.convertCell2Field("NO"));
		assertEquals(true, converter.convertCell2Field("yes"));
		assertEquals(false, converter.convertCell2Field("no"));
		assertEquals(false, converter.convertCell2Field("Y"));
		assertEquals(false, converter.convertCell2Field("N"));
		assertEquals(true, converter.convertCell2Field("y"));
		assertEquals(false, converter.convertCell2Field("n"));
		assertEquals(false, converter.convertCell2Field("YeS"));
		assertEquals(false, converter.convertCell2Field("nO"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("no", converter.convertField2Cell("Yes"));
		assertEquals("no", converter.convertField2Cell("No"));
		assertEquals("no", converter.convertField2Cell("YES"));
		assertEquals("no", converter.convertField2Cell("NO"));
		assertEquals("no", converter.convertField2Cell("yes"));
		assertEquals("no", converter.convertField2Cell("no"));
		assertEquals("no", converter.convertField2Cell("Y"));
		assertEquals("no", converter.convertField2Cell("N"));
		assertEquals("no", converter.convertField2Cell("y"));
		assertEquals("no", converter.convertField2Cell("n"));
		assertEquals("no", converter.convertField2Cell("YeS"));
		assertEquals("no", converter.convertField2Cell("nO"));
		assertEquals("yes", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("no", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("yes", converter.convertField2Cell(true));
		assertEquals("no", converter.convertField2Cell(false));
		assertEquals("no", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testYesNoCapitalizeUpperCase() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_YES_NO);
		converter.setCapitalizeType(CapitalizeType.UPPER_CASE);
		assertEquals(true, converter.convertCell2Field("Yes"));
		assertEquals(false, converter.convertCell2Field("No"));
		assertEquals(true, converter.convertCell2Field("YES"));
		assertEquals(false, converter.convertCell2Field("NO"));
		assertEquals(true, converter.convertCell2Field("yes"));
		assertEquals(false, converter.convertCell2Field("no"));
		assertEquals(true, converter.convertCell2Field("Y"));
		assertEquals(false, converter.convertCell2Field("N"));
		assertEquals(true, converter.convertCell2Field("y"));
		assertEquals(false, converter.convertCell2Field("n"));
		assertEquals(true, converter.convertCell2Field("YeS"));
		assertEquals(false, converter.convertCell2Field("nO"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("NO", converter.convertField2Cell("Yes"));
		assertEquals("NO", converter.convertField2Cell("No"));
		assertEquals("NO", converter.convertField2Cell("YES"));
		assertEquals("NO", converter.convertField2Cell("NO"));
		assertEquals("NO", converter.convertField2Cell("yes"));
		assertEquals("NO", converter.convertField2Cell("no"));
		assertEquals("NO", converter.convertField2Cell("Y"));
		assertEquals("NO", converter.convertField2Cell("N"));
		assertEquals("NO", converter.convertField2Cell("y"));
		assertEquals("NO", converter.convertField2Cell("n"));
		assertEquals("NO", converter.convertField2Cell("YeS"));
		assertEquals("NO", converter.convertField2Cell("nO"));
		assertEquals("YES", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("NO", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("YES", converter.convertField2Cell(true));
		assertEquals("NO", converter.convertField2Cell(false));
		assertEquals("NO", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testYesNoIgnoreCaseNoCapitalizeUpperCase() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_YES_NO);
		converter.setIgnoreCase(false);
		converter.setCapitalizeType(CapitalizeType.UPPER_CASE);
		assertEquals(false, converter.convertCell2Field("Yes"));
		assertEquals(false, converter.convertCell2Field("No"));
		assertEquals(false, converter.convertCell2Field("YES"));
		assertEquals(false, converter.convertCell2Field("NO"));
		assertEquals(true, converter.convertCell2Field("yes"));
		assertEquals(false, converter.convertCell2Field("no"));
		assertEquals(false, converter.convertCell2Field("Y"));
		assertEquals(false, converter.convertCell2Field("N"));
		assertEquals(true, converter.convertCell2Field("y"));
		assertEquals(false, converter.convertCell2Field("n"));
		assertEquals(false, converter.convertCell2Field("YeS"));
		assertEquals(false, converter.convertCell2Field("nO"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("NO", converter.convertField2Cell("Yes"));
		assertEquals("NO", converter.convertField2Cell("No"));
		assertEquals("NO", converter.convertField2Cell("YES"));
		assertEquals("NO", converter.convertField2Cell("NO"));
		assertEquals("NO", converter.convertField2Cell("yes"));
		assertEquals("NO", converter.convertField2Cell("no"));
		assertEquals("NO", converter.convertField2Cell("Y"));
		assertEquals("NO", converter.convertField2Cell("N"));
		assertEquals("NO", converter.convertField2Cell("y"));
		assertEquals("NO", converter.convertField2Cell("n"));
		assertEquals("NO", converter.convertField2Cell("YeS"));
		assertEquals("NO", converter.convertField2Cell("nO"));
		assertEquals("YES", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("NO", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("YES", converter.convertField2Cell(true));
		assertEquals("NO", converter.convertField2Cell(false));
		assertEquals("NO", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testCapitalizeLowerCase() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setCapitalizeType(CapitalizeType.LOWER_CASE);
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(true, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(true, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(true, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("false", converter.convertField2Cell("true"));
		assertEquals("false", converter.convertField2Cell("false"));
		assertEquals("false", converter.convertField2Cell("TRUE"));
		assertEquals("false", converter.convertField2Cell("FALSE"));
		assertEquals("false", converter.convertField2Cell("True"));
		assertEquals("false", converter.convertField2Cell("False"));
		assertEquals("false", converter.convertField2Cell("tRue"));
		assertEquals("false", converter.convertField2Cell("fAlse"));
		assertEquals("true", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("false", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("true", converter.convertField2Cell(true));
		assertEquals("false", converter.convertField2Cell(false));
		assertEquals("false", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testCapitalizeCapitalize() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setCapitalizeType(CapitalizeType.CAPITALIZE);
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(true, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(true, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(true, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("False", converter.convertField2Cell("true"));
		assertEquals("False", converter.convertField2Cell("false"));
		assertEquals("False", converter.convertField2Cell("TRUE"));
		assertEquals("False", converter.convertField2Cell("FALSE"));
		assertEquals("False", converter.convertField2Cell("True"));
		assertEquals("False", converter.convertField2Cell("False"));
		assertEquals("False", converter.convertField2Cell("tRue"));
		assertEquals("False", converter.convertField2Cell("fAlse"));
		assertEquals("True", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("False", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("True", converter.convertField2Cell(true));
		assertEquals("False", converter.convertField2Cell(false));
		assertEquals("False", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testCapitalizeUnCapitalize() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setCapitalizeType(CapitalizeType.UN_CAPITARIZE);
		assertEquals(true, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(true, converter.convertCell2Field("TRUE"));
		assertEquals(false, converter.convertCell2Field("FALSE"));
		assertEquals(true, converter.convertCell2Field("True"));
		assertEquals(false, converter.convertCell2Field("False"));
		assertEquals(true, converter.convertCell2Field("tRue"));
		assertEquals(false, converter.convertCell2Field("fAlse"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));

		assertEquals("false", converter.convertField2Cell("true"));
		assertEquals("false", converter.convertField2Cell("false"));
		assertEquals("false", converter.convertField2Cell("TRUE"));
		assertEquals("false", converter.convertField2Cell("FALSE"));
		assertEquals("false", converter.convertField2Cell("True"));
		assertEquals("false", converter.convertField2Cell("False"));
		assertEquals("false", converter.convertField2Cell("tRue"));
		assertEquals("false", converter.convertField2Cell("fAlse"));
		assertEquals("true", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("false", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("true", converter.convertField2Cell(true));
		assertEquals("false", converter.convertField2Cell(false));
		assertEquals("false", converter.convertField2Cell("XXX"));
	}

	@Test
	public void testOX() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_OX);
		assertEquals(true, converter.convertCell2Field(""));
		assertEquals(false, converter.convertCell2Field("~"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals("~", converter.convertField2Cell(""));
		assertEquals("~", converter.convertField2Cell("~"));
		assertEquals("", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("~", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("", converter.convertField2Cell(true));
		assertEquals("~", converter.convertField2Cell(false));
		assertEquals("~", converter.convertField2Cell("XXX"));
		assertEquals("~", converter.convertField2Cell("true"));
		assertEquals("~", converter.convertField2Cell("false"));
	}

	@Test
	public void testOnOff() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_ON_OFF);
		assertEquals(true, converter.convertCell2Field("on"));
		assertEquals(false, converter.convertCell2Field("off"));
		assertEquals(true, converter.convertCell2Field("ON"));
		assertEquals(false, converter.convertCell2Field("OFF"));
		assertEquals(true, converter.convertCell2Field("On"));
		assertEquals(false, converter.convertCell2Field("Off"));
		assertEquals(true, converter.convertCell2Field("oN"));
		assertEquals(false, converter.convertCell2Field("oFf"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals("off", converter.convertField2Cell("on"));
		assertEquals("off", converter.convertField2Cell("off"));
		assertEquals("off", converter.convertField2Cell("ON"));
		assertEquals("off", converter.convertField2Cell("OFF"));
		assertEquals("off", converter.convertField2Cell("On"));
		assertEquals("off", converter.convertField2Cell("Off"));
		assertEquals("off", converter.convertField2Cell("oN"));
		assertEquals("off", converter.convertField2Cell("oFf"));
		assertEquals("on", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("off", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("on", converter.convertField2Cell(true));
		assertEquals("off", converter.convertField2Cell(false));
		assertEquals("off", converter.convertField2Cell("XXX"));
		assertEquals("off", converter.convertField2Cell("true"));
		assertEquals("off", converter.convertField2Cell("false"));
	}

	@Test
	public void test10() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_10);
		assertEquals(true, converter.convertCell2Field("1"));
		assertEquals(false, converter.convertCell2Field("0"));
		assertEquals(false, converter.convertCell2Field(1));
		assertEquals(false, converter.convertCell2Field(0));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals("0", converter.convertField2Cell("1"));
		assertEquals("0", converter.convertField2Cell("0"));
		assertEquals("0", converter.convertField2Cell(1));
		assertEquals("0", converter.convertField2Cell(0));
		assertEquals("1", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("0", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("1", converter.convertField2Cell(true));
		assertEquals("0", converter.convertField2Cell(false));
		assertEquals("0", converter.convertField2Cell("XXX"));
		assertEquals("0", converter.convertField2Cell("true"));
		assertEquals("0", converter.convertField2Cell("false"));
	}

	@Test
	public void test10Integer() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_10_INTEGER);
		assertEquals(true, converter.convertCell2Field(1));
		assertEquals(false, converter.convertCell2Field(0));
		assertEquals(false, converter.convertCell2Field("1"));
		assertEquals(false, converter.convertCell2Field("0"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals(0, converter.convertField2Cell(1));
		assertEquals(0, converter.convertField2Cell(0));
		assertEquals(0, converter.convertField2Cell("1"));
		assertEquals(0, converter.convertField2Cell("0"));
		assertEquals(1, converter.convertField2Cell(Boolean.TRUE));
		assertEquals(0, converter.convertField2Cell(Boolean.FALSE));
		assertEquals(1, converter.convertField2Cell(true));
		assertEquals(0, converter.convertField2Cell(false));
		assertEquals(0, converter.convertField2Cell("XXX"));
		assertEquals(0, converter.convertField2Cell("true"));
		assertEquals(0, converter.convertField2Cell("false"));
	}

	@Test
	public void testOkCancel() throws ExcelPOJOException {
		StringBooleanConverter converter = new StringBooleanConverter();
		converter.setMappings(StringBooleanConverter.TYPE_OK_CANCEL);
		assertEquals(true, converter.convertCell2Field("ok"));
		assertEquals(false, converter.convertCell2Field("cancel"));
		assertEquals(true, converter.convertCell2Field("OK"));
		assertEquals(false, converter.convertCell2Field("CANCEL"));
		assertEquals(true, converter.convertCell2Field("Ok"));
		assertEquals(false, converter.convertCell2Field("Cancel"));
		assertEquals(true, converter.convertCell2Field("oK"));
		assertEquals(false, converter.convertCell2Field("cAncel"));
		assertEquals(false, converter.convertCell2Field(Boolean.TRUE));
		assertEquals(false, converter.convertCell2Field(Boolean.FALSE));
		assertEquals(false, converter.convertCell2Field(true));
		assertEquals(false, converter.convertCell2Field(false));
		assertEquals(false, converter.convertCell2Field("XXX"));
		assertEquals(false, converter.convertCell2Field("true"));
		assertEquals(false, converter.convertCell2Field("false"));

		assertEquals("cancel", converter.convertField2Cell("ok"));
		assertEquals("cancel", converter.convertField2Cell("cancel"));
		assertEquals("cancel", converter.convertField2Cell("OK"));
		assertEquals("cancel", converter.convertField2Cell("CANCEL"));
		assertEquals("cancel", converter.convertField2Cell("Ok"));
		assertEquals("cancel", converter.convertField2Cell("Cancel"));
		assertEquals("cancel", converter.convertField2Cell("oK"));
		assertEquals("cancel", converter.convertField2Cell("cAncel"));
		assertEquals("ok", converter.convertField2Cell(Boolean.TRUE));
		assertEquals("cancel", converter.convertField2Cell(Boolean.FALSE));
		assertEquals("ok", converter.convertField2Cell(true));
		assertEquals("cancel", converter.convertField2Cell(false));
		assertEquals("cancel", converter.convertField2Cell("XXX"));
		assertEquals("cancel", converter.convertField2Cell("true"));
		assertEquals("cancel", converter.convertField2Cell("false"));
	}

}
